/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.controllers.IScriptHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.ClientScriptData;
import org.apache.commons.codec.digest.DigestUtils;

public class ScriptEncryption {
    private static final int SALT_LENGTH = 8;

    public static boolean encryptScript(File outputFile, String fileName, String scriptCode, boolean onlyTab, ScriptContainer sContainer, IScriptHandler handler) {
        Cipher cipher;
        SecretKey secretKey;
        if (handler instanceof ClientScriptData) {
            LogWriter.error("Error trying to encrypt script code: Trying to encrypt script for client: " + outputFile.getAbsolutePath());
            return false;
        }
        try {
            secretKey = ScriptEncryption.generateSecretKey();
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            LogWriter.error("Error trying to encrypt script code: Failed to create key-password for file: " + outputFile.getAbsolutePath(), e);
            return false;
        }
        try (OutputStream outStream = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
            byte[] iv = new byte[cipher.getBlockSize()];
            Arrays.fill(iv, (byte)0);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)secretKey, ivParams);
            byte[] encryptedData = cipher.doFinal(scriptCode.getBytes());
            outStream.write(iv);
            outStream.write(encryptedData);
            LogWriter.info("Script code (length:" + scriptCode.length() + ") is encrypted into a file: \"" + outputFile.getAbsolutePath() + "\" for " + handler.getClass().getSimpleName());
        }
        catch (Exception e) {
            LogWriter.error("Error while trying to encrypt script code: Failed to encrypt and save code to file: " + outputFile.getAbsolutePath(), e);
            return false;
        }
        ScriptController sData = ScriptController.Instance;
        sData.sizes.put(fileName, outputFile.length());
        sData.scripts.remove(fileName);
        sData.encrypts.put(fileName, outputFile);
        sContainer.script = "";
        if (!onlyTab) {
            sContainer.scripts.clear();
        }
        sContainer.scripts.add(fileName);
        sContainer.lastCreated = 0L;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decryptScriptFromFile(File inputFile) {
        Cipher cipher;
        SecretKey secretKey;
        try {
            secretKey = ScriptEncryption.generateSecretKey();
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            LogWriter.error("Error trying to encrypt script code: Failed to create key-password", e);
            return null;
        }
        try (InputStream inStream = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);){
            int readBytes;
            byte[] iv = new byte[cipher.getBlockSize()];
            if (inStream.read(iv) == -1) {
                LogWriter.error("Error decrypting file - \"Failed to read IV\"");
                String string2 = null;
                return string2;
            }
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(2, (Key)secretKey, ivParams);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((readBytes = inStream.read(buffer)) != -1) {
                baos.write(cipher.update(buffer, 0, readBytes));
            }
            baos.write(cipher.doFinal());
            String scriptCode = baos.toString();
            LogWriter.info("File: \"" + inputFile.getAbsolutePath() + "\" has been decrypted into script code (length:" + scriptCode.length() + ")");
            String string = scriptCode;
            return string;
        }
        catch (Exception e) {
            LogWriter.error("Error decrypting file", e);
            return null;
        }
    }

    private static SecretKey generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        byte[] hashedPass = DigestUtils.md5((byte[])CustomNpcs.ScriptPassword.getBytes());
        return new SecretKeySpec(hashedPass, "AES");
    }
}

